/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.property.listeners;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.property.PluginPropertyChangeListener;
import eu.domibus.plugin.webService.logging.WSPluginLoggingEventSender;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class WSPluginLoggingApacheCXFChangeListener
implements PluginPropertyChangeListener {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(WSPluginLoggingApacheCXFChangeListener.class);
    private final LoggingFeature wsLoggingFeature;
    private final WSPluginLoggingEventSender wsPluginLoggingEventSender;

    public WSPluginLoggingApacheCXFChangeListener(@Qualifier(value="wsLoggingFeature") LoggingFeature wsLoggingFeature, @Qualifier(value="wsPluginLoggingEventSender") WSPluginLoggingEventSender wsPluginLoggingEventSender) {
        this.wsLoggingFeature = wsLoggingFeature;
        this.wsPluginLoggingEventSender = wsPluginLoggingEventSender;
    }

    public boolean handlesProperty(String propertyName) {
        boolean doesHandle = StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"domibus.logging.cxf.limit", "domibus.logging.payload.print", "domibus.logging.metadata.print"});
        LOG.trace("Handling [{}] property: [{}]", (Object)propertyName, (Object)doesHandle);
        return doesHandle;
    }

    public void propertyValueChanged(String domainCode, String propertyName, String propertyValue) {
        String logDebugMsg = "Setting [{}] property to [{}] on domain: [{}]";
        switch (propertyName) {
            case "domibus.logging.cxf.limit": {
                int cxfLimit = NumberUtils.toInt((String)propertyValue);
                LOG.debug(logDebugMsg, new Object[]{propertyName, cxfLimit, domainCode});
                this.wsLoggingFeature.setLimit(cxfLimit);
                break;
            }
            case "domibus.logging.payload.print": {
                boolean printPayload = BooleanUtils.toBoolean((String)propertyValue);
                LOG.debug(logDebugMsg, new Object[]{propertyName, printPayload, domainCode});
                this.wsPluginLoggingEventSender.setPrintPayload(printPayload);
                break;
            }
            case "domibus.logging.metadata.print": {
                boolean metadataPrint = BooleanUtils.toBoolean((String)propertyValue);
                LOG.debug(logDebugMsg, new Object[]{propertyName, metadataPrint, domainCode});
                this.wsPluginLoggingEventSender.setPrintMetadata(metadataPrint);
            }
        }
    }
}

