/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.property.listeners;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.property.PluginPropertyChangeListener;
import javax.xml.ws.Endpoint;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SchemaValidationEnabledChangeListener
implements PluginPropertyChangeListener {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(SchemaValidationEnabledChangeListener.class);
    private final Endpoint backendInterfaceEndpoint;

    public SchemaValidationEnabledChangeListener(@Qualifier(value="backendInterfaceEndpoint") Endpoint backendInterfaceEndpoint) {
        this.backendInterfaceEndpoint = backendInterfaceEndpoint;
    }

    public boolean handlesProperty(String propertyName) {
        boolean doesHandle = StringUtils.equals((CharSequence)propertyName, (CharSequence)"wsplugin.schema.validation.enabled");
        LOG.trace("Handling [{}] property: [{}]", (Object)propertyName, (Object)doesHandle);
        return doesHandle;
    }

    public void propertyValueChanged(String domainCode, String propertyName, String propertyValue) {
        LOG.trace("Setting [{}] property to [{}] on domain: [{}]", new Object[]{propertyName, propertyValue, domainCode});
        this.backendInterfaceEndpoint.getProperties().put("schema-validation-enabled", propertyValue);
    }
}

