/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.property.listeners;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.property.PluginPropertyChangeListener;
import javax.xml.ws.Endpoint;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MtomEnabledChangeListener
implements PluginPropertyChangeListener {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(MtomEnabledChangeListener.class);
    private final Endpoint backendInterfaceEndpoint;

    public MtomEnabledChangeListener(@Qualifier(value="backendInterfaceEndpoint") Endpoint backendInterfaceEndpoint) {
        this.backendInterfaceEndpoint = backendInterfaceEndpoint;
    }

    public boolean handlesProperty(String propertyName) {
        boolean doesHandle = StringUtils.equals((CharSequence)propertyName, (CharSequence)"wsplugin.mtom.enabled");
        LOG.trace("Handling [{}] property: [{}]", (Object)propertyName, (Object)doesHandle);
        return doesHandle;
    }

    public void propertyValueChanged(String domainCode, String propertyName, String propertyValue) {
        Boolean val = Boolean.valueOf(propertyValue);
        LOG.trace("Setting [{}] property to [{}] on domain: [{}]", new Object[]{propertyName, val, domainCode});
        ((SOAPBinding)this.backendInterfaceEndpoint.getBinding()).setMTOMEnabled(val.booleanValue());
    }
}

