/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.logging;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.webService.logging.WSPluginLoggingEventHelper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogMessageFormatter;
import org.apache.cxf.ext.logging.slf4j.Slf4jEventSender;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WSPluginLoggingEventSender
extends Slf4jEventSender {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(WSPluginLoggingEventSender.class);
    static final String ORG_APACHE_CXF_CATEGORY = "org.apache.cxf";
    private boolean printPayload;
    private boolean printMetadata;
    @Autowired
    WSPluginLoggingEventHelper wsPluginLoggingEventHelper;

    public void setPrintPayload(boolean printPayload) {
        this.printPayload = printPayload;
    }

    public void setPrintMetadata(boolean printMetadata) {
        this.printMetadata = printMetadata;
    }

    protected String getLogMessage(LogEvent event) {
        if (!this.isCxfLoggingInfoEnabled()) {
            return "";
        }
        try {
            this.wsPluginLoggingEventHelper.stripHeaders(event);
            if (this.checkIfStripPayloadPossible()) {
                this.wsPluginLoggingEventHelper.stripPayload(event);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Exception while stripping the payload: ", (Throwable)e);
        }
        if (this.printMetadata) {
            LOG.debug("Apache CXF logging metadata will be printed");
            return LogMessageFormatter.format((LogEvent)event);
        }
        return event.getPayload();
    }

    protected boolean checkIfStripPayloadPossible() {
        LOG.debug("Printing payload is{}active", (Object)(this.printPayload ? " " : " not "));
        return !this.printPayload;
    }

    protected boolean isCxfLoggingInfoEnabled() {
        boolean isCxfLoggingInfoEnabled = LoggerFactory.getLogger((String)ORG_APACHE_CXF_CATEGORY).isInfoEnabled();
        LOG.debug("[{}] is {}set to INFO level", (Object)ORG_APACHE_CXF_CATEGORY, (Object)(isCxfLoggingInfoEnabled ? "" : "not "));
        return isCxfLoggingInfoEnabled;
    }
}

