/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.logging;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.webService.logging.WSPluginLoggingEventHelper;
import java.util.Map;
import org.apache.cxf.ext.logging.event.EventType;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WSPluginLoggingEventHelperImpl
implements WSPluginLoggingEventHelper {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(WSPluginLoggingEventHelperImpl.class);
    static final String BOUNDARY_MARKER = "boundary=\"";
    static final String BOUNDARY_MARKER_PREFIX = "--";
    static final String CONTENT_TYPE_MARKER = "Content-Type:";
    static final String VALUE_START_MARKER = "<value";
    static final String VALUE_END_MARKER = "</value";
    static final String RETRIEVE_MESSAGE_RESPONSE = "retrieveMessageResponse";
    static final String SUBMIT_REQUEST = "submitRequest";
    static final String OPERATION_SUBMIT_MESSAGE = "submitMessage";
    static final String OPERATION_RETRIEVE_MESSAGE = "retrieveMessage";
    static final String HEADERS_AUTHORIZATION = "Authorization";

    @Override
    public void stripPayload(LogEvent event) {
        String operationName = event.getOperationName();
        EventType eventType = event.getType();
        LOG.debug("operationName=[{}] eventType=[{}] multipart=[{}]", new Object[]{operationName, eventType, event.isMultipartContent()});
        String payload = event.getPayload();
        String xmlNode = this.checkIfOperationIsAllowed(event);
        if (xmlNode == null) {
            LOG.debug("payload not striped for operationName=[{}] eventType=[{}]", (Object)operationName, (Object)eventType);
            return;
        }
        if (event.isMultipartContent()) {
            String boundary = this.getMultipartBoundary(event.getContentType());
            payload = this.replaceInPayloadMultipart(payload, boundary, xmlNode);
        } else {
            payload = this.replaceInPayloadValues(payload, xmlNode);
        }
        event.setPayload(payload);
    }

    @Override
    public void stripHeaders(LogEvent event) {
        Map headers = event.getHeaders();
        if (CollectionUtils.isEmpty((Map)headers)) {
            LOG.debug("no apache cxf headers to strip");
            return;
        }
        headers.entrySet().removeIf(e -> HEADERS_AUTHORIZATION.equalsIgnoreCase((String)e.getKey()));
    }

    @Override
    public String checkIfOperationIsAllowed(LogEvent logEvent) {
        if (logEvent.getType() == EventType.REQ_IN && logEvent.getOperationName().contains(OPERATION_SUBMIT_MESSAGE)) {
            return SUBMIT_REQUEST;
        }
        if (logEvent.getType() == EventType.RESP_OUT && logEvent.getOperationName().contains(OPERATION_RETRIEVE_MESSAGE)) {
            return RETRIEVE_MESSAGE_RESPONSE;
        }
        return null;
    }

    private String replaceInPayloadMultipart(String payload, String boundary, String xmlTag) {
        String newPayload = payload;
        String[] payloadSplits = payload.split(boundary);
        if (payloadSplits.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < payloadSplits.length; ++i) {
                stringBuilder.append(this.getReplacementPart(payloadSplits[i], xmlTag));
                if (i == payloadSplits.length - 1) continue;
                stringBuilder.append(boundary);
            }
            newPayload = stringBuilder.toString();
        }
        return newPayload;
    }

    private String getMultipartBoundary(String contentType) {
        String[] contentTypeSplits = contentType.split(BOUNDARY_MARKER);
        if (contentTypeSplits.length >= 2) {
            return BOUNDARY_MARKER_PREFIX + contentTypeSplits[1].substring(0, contentTypeSplits[1].length() - 1);
        }
        return "";
    }

    private String getReplacementPart(String boundarySplit, String xmlTag) {
        if (boundarySplit.contains(CONTENT_TYPE_MARKER) && !boundarySplit.contains(xmlTag)) {
            return System.lineSeparator() + "--- Content suppressed ---" + System.lineSeparator();
        }
        return boundarySplit;
    }

    private String replaceInPayloadValues(String payload, String xmlNode) {
        String newPayload = payload;
        int xmlNodeStartIndex = newPayload.indexOf(xmlNode);
        if (xmlNodeStartIndex == -1) {
            LOG.debug("[{}] xml node wasn't found in the payload so no striping will occur", (Object)xmlNode);
            return newPayload;
        }
        int indexStart = newPayload.indexOf(VALUE_START_MARKER);
        int startTagLength = newPayload.indexOf(62, indexStart) - indexStart + 1;
        int indexEnd = newPayload.indexOf(VALUE_END_MARKER);
        int endTagLength = newPayload.indexOf(62, indexEnd) - indexEnd + 1;
        while (indexStart >= 0 && indexStart > xmlNodeStartIndex && indexStart < indexEnd) {
            String toBeReplaced = newPayload.substring(indexStart + startTagLength, indexEnd);
            newPayload = newPayload.replace(toBeReplaced, "--- Content suppressed ---");
            int fromIndex = indexEnd + endTagLength + "--- Content suppressed ---".length() - toBeReplaced.length() + 1;
            indexStart = newPayload.indexOf(VALUE_START_MARKER, fromIndex);
            indexEnd = newPayload.indexOf(VALUE_END_MARKER, fromIndex);
            startTagLength = newPayload.indexOf(62, indexStart) - indexStart + 1;
            endTagLength = newPayload.indexOf(62, indexEnd) - indexEnd + 1;
        }
        return newPayload;
    }
}

