/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.impl;

import eu.domibus.common.DeliverMessageEvent;
import eu.domibus.common.MessageDeletedBatchEvent;
import eu.domibus.common.MessageDeletedEvent;
import eu.domibus.common.MessageReceiveFailureEvent;
import eu.domibus.common.MessageSendFailedEvent;
import eu.domibus.common.MessageSendSuccessEvent;
import eu.domibus.common.MessageStatusChangeEvent;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.ObjectFactory;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartProperties;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PayloadInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import eu.domibus.ext.domain.DomainDTO;
import eu.domibus.ext.exceptions.AuthenticationExtException;
import eu.domibus.ext.exceptions.MessageAcknowledgeExtException;
import eu.domibus.ext.services.AuthenticationExtService;
import eu.domibus.ext.services.DomainContextExtService;
import eu.domibus.ext.services.DomainExtService;
import eu.domibus.ext.services.MessageAcknowledgeExtService;
import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.logging.DomibusMessageCode;
import eu.domibus.logging.MDCKey;
import eu.domibus.messaging.MessageNotFoundException;
import eu.domibus.messaging.MessagingProcessingException;
import eu.domibus.plugin.AbstractBackendConnector;
import eu.domibus.plugin.transformer.MessageRetrievalTransformer;
import eu.domibus.plugin.transformer.MessageSubmissionTransformer;
import eu.domibus.plugin.webService.dao.WSMessageLogDao;
import eu.domibus.plugin.webService.entity.WSMessageLogEntity;
import eu.domibus.plugin.webService.generated.BackendInterface;
import eu.domibus.plugin.webService.generated.ErrorCode;
import eu.domibus.plugin.webService.generated.ErrorResultImplArray;
import eu.domibus.plugin.webService.generated.FaultDetail;
import eu.domibus.plugin.webService.generated.GetErrorsRequest;
import eu.domibus.plugin.webService.generated.LargePayloadType;
import eu.domibus.plugin.webService.generated.ListPendingMessagesResponse;
import eu.domibus.plugin.webService.generated.MessageStatus;
import eu.domibus.plugin.webService.generated.RetrieveMessageFault;
import eu.domibus.plugin.webService.generated.RetrieveMessageRequest;
import eu.domibus.plugin.webService.generated.RetrieveMessageResponse;
import eu.domibus.plugin.webService.generated.StatusFault;
import eu.domibus.plugin.webService.generated.StatusRequest;
import eu.domibus.plugin.webService.generated.SubmitMessageFault;
import eu.domibus.plugin.webService.generated.SubmitRequest;
import eu.domibus.plugin.webService.generated.SubmitResponse;
import eu.domibus.plugin.webService.impl.ExtendedPartInfo;
import eu.domibus.plugin.webService.impl.StubDtoTransformer;
import eu.domibus.plugin.webService.impl.WebServicePluginExceptionFactory;
import eu.domibus.plugin.webService.property.WSPluginPropertyManager;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.Holder;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.common.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@WebService(serviceName="BackendService_1_1", portName="BACKEND_PORT", targetNamespace="http://org.ecodex.backend/1_1/", endpointInterface="eu.domibus.plugin.webService.generated.BackendInterface")
@BindingType(value="http://www.w3.org/2003/05/soap/bindings/HTTP/")
public class WebServicePluginImpl
extends AbstractBackendConnector<Messaging, UserMessage>
implements BackendInterface {
    public static final String PLUGIN_NAME = "backendWebservice";
    public static final String MESSAGE_SUBMISSION_FAILED = "Message submission failed";
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(WebServicePluginImpl.class);
    public static final eu.domibus.plugin.webService.generated.ObjectFactory WEBSERVICE_OF = new eu.domibus.plugin.webService.generated.ObjectFactory();
    private static final ObjectFactory EBMS_OBJECT_FACTORY = new ObjectFactory();
    private static final String MIME_TYPE = "MimeType";
    private static final String MESSAGE_ID_EMPTY = "Message ID is empty";
    private static final String MESSAGE_NOT_FOUND_ID = "Message not found, id [";
    @Autowired
    private StubDtoTransformer defaultTransformer;
    @Autowired
    private MessageAcknowledgeExtService messageAcknowledgeExtService;
    @Autowired
    protected WebServicePluginExceptionFactory webServicePluginExceptionFactory;
    @Autowired
    protected WSMessageLogDao wsMessageLogDao;
    @Autowired
    protected DomainExtService domainExtService;
    @Autowired
    private DomainContextExtService domainContextExtService;
    @Autowired
    protected WSPluginPropertyManager wsPluginPropertyManager;
    @Autowired
    AuthenticationExtService authenticationExtService;

    public WebServicePluginImpl() {
        super(PLUGIN_NAME);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, timeout=1200)
    public SubmitResponse submitMessage(SubmitRequest submitRequest, Messaging ebMSHeaderInfo) throws SubmitMessageFault {
        String messageId;
        LOG.debug("Received message");
        this.addPartInfos(submitRequest, ebMSHeaderInfo);
        if (ebMSHeaderInfo.getUserMessage().getMessageInfo() == null) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTimestamp(LocalDateTime.now());
            ebMSHeaderInfo.getUserMessage().setMessageInfo(messageInfo);
        } else {
            String submittedMessageId = ebMSHeaderInfo.getUserMessage().getMessageInfo().getMessageId();
            if (StringUtils.isNotEmpty((CharSequence)submittedMessageId)) {
                LOG.debug("Submitted messageId=[{}]", (Object)submittedMessageId);
                String trimmedMessageId = this.messageExtService.cleanMessageIdentifier(submittedMessageId);
                ebMSHeaderInfo.getUserMessage().getMessageInfo().setMessageId(trimmedMessageId);
            }
        }
        try {
            messageId = this.submit(ebMSHeaderInfo);
        }
        catch (MessagingProcessingException mpEx) {
            LOG.error(MESSAGE_SUBMISSION_FAILED, (Throwable)mpEx);
            throw new SubmitMessageFault(MESSAGE_SUBMISSION_FAILED, this.generateFaultDetail(mpEx));
        }
        LOG.info("Received message from backend with messageID [{}]", (Object)messageId);
        SubmitResponse response = WEBSERVICE_OF.createSubmitResponse();
        response.getMessageID().add(messageId);
        return response;
    }

    public void deliverMessage(DeliverMessageEvent event) {
        LOG.info("Deliver message: [{}]", (Object)event);
        WSMessageLogEntity wsMessageLogEntity = new WSMessageLogEntity(event.getMessageId(), event.getFinalRecipient(), new Date());
        this.wsMessageLogDao.create(wsMessageLogEntity);
    }

    public void messageReceiveFailed(MessageReceiveFailureEvent event) {
        LOG.info("Message receive failed [{}]", (Object)event);
    }

    public void messageStatusChanged(MessageStatusChangeEvent event) {
        LOG.info("Message status changed [{}]", (Object)event);
    }

    public void messageSendFailed(MessageSendFailedEvent event) {
        LOG.info("Message send failed [{}]", (Object)event);
    }

    public void messageDeletedBatchEvent(MessageDeletedBatchEvent event) {
        LOG.info("Message delete batch event [{}]", (Object)event.getMessageIds());
        this.wsMessageLogDao.deleteByMessageIds(event.getMessageIds());
    }

    public void messageDeletedEvent(MessageDeletedEvent event) {
        LOG.info("Message delete event [{}]", (Object)event.getMessageId());
        this.wsMessageLogDao.deleteByMessageId(event.getMessageId());
    }

    public void messageSendSuccess(MessageSendSuccessEvent event) {
        LOG.info("Message send success [{}]", (Object)event.getMessageId());
    }

    private void addPartInfos(SubmitRequest submitRequest, Messaging ebMSHeaderInfo) throws SubmitMessageFault {
        if (this.getPayloadInfo(ebMSHeaderInfo) == null) {
            return;
        }
        this.validateSubmitRequest(submitRequest, ebMSHeaderInfo);
        List<PartInfo> partInfoList = this.getPartInfo(ebMSHeaderInfo);
        ArrayList<ExtendedPartInfo> partInfosToAdd = new ArrayList<ExtendedPartInfo>();
        Iterator<PartInfo> i = partInfoList.iterator();
        while (i.hasNext()) {
            ExtendedPartInfo extendedPartInfo = new ExtendedPartInfo(i.next());
            partInfosToAdd.add(extendedPartInfo);
            i.remove();
            boolean foundPayload = false;
            String href = extendedPartInfo.getHref();
            LOG.debug("Looking for payload: {}", (Object)href);
            for (LargePayloadType payload : submitRequest.getPayload()) {
                LOG.debug("comparing with payload id: " + payload.getPayloadId());
                if (!StringUtils.equalsIgnoreCase((CharSequence)payload.getPayloadId(), (CharSequence)href)) continue;
                this.copyPartProperties(payload.getContentType(), extendedPartInfo);
                extendedPartInfo.setInBody(false);
                LOG.debug("sendMessage - payload Content Type: " + payload.getContentType());
                extendedPartInfo.setPayloadDatahandler(payload.getValue());
                foundPayload = true;
                break;
            }
            if (foundPayload) continue;
            LargePayloadType bodyload = submitRequest.getBodyload();
            if (bodyload == null) {
                throw new SubmitMessageFault("No Payload or Bodyload found for PartInfo with href: " + extendedPartInfo.getHref(), this.generateDefaultFaultDetail(extendedPartInfo.getHref()));
            }
            if (href == null && bodyload.getPayloadId() == null || href != null && StringUtils.equalsIgnoreCase((CharSequence)href, (CharSequence)bodyload.getPayloadId())) {
                this.copyPartProperties(bodyload.getContentType(), extendedPartInfo);
                extendedPartInfo.setInBody(true);
                LOG.debug("sendMessage - bodyload Content Type: " + bodyload.getContentType());
                extendedPartInfo.setPayloadDatahandler(bodyload.getValue());
                continue;
            }
            throw new SubmitMessageFault("No payload found for PartInfo with href: " + extendedPartInfo.getHref(), this.generateDefaultFaultDetail(extendedPartInfo.getHref()));
        }
        partInfoList.addAll(partInfosToAdd);
    }

    protected void validateSubmitRequest(SubmitRequest submitRequest, Messaging ebMSHeaderInfo) throws SubmitMessageFault {
        for (LargePayloadType payload : submitRequest.getPayload()) {
            if (!StringUtils.isBlank((CharSequence)payload.getPayloadId())) continue;
            throw new SubmitMessageFault("Invalid request", this.generateDefaultFaultDetail("Attribute 'payloadId' of the 'payload' element must not be empty"));
        }
        LargePayloadType bodyload = submitRequest.getBodyload();
        if (bodyload != null && StringUtils.isNotBlank((CharSequence)bodyload.getPayloadId())) {
            throw new SubmitMessageFault("Invalid request", this.generateDefaultFaultDetail("Attribute 'payloadId' must not appear on element 'bodyload'"));
        }
    }

    private FaultDetail generateFaultDetail(MessagingProcessingException mpEx) {
        FaultDetail fd = WEBSERVICE_OF.createFaultDetail();
        fd.setCode(mpEx.getEbms3ErrorCode().getErrorCodeName());
        fd.setMessage(mpEx.getMessage());
        return fd;
    }

    private FaultDetail generateDefaultFaultDetail(String message) {
        FaultDetail fd = WEBSERVICE_OF.createFaultDetail();
        fd.setCode(ErrorCode.EBMS_0004.name());
        fd.setMessage(message);
        return fd;
    }

    private void copyPartProperties(String payloadContentType, ExtendedPartInfo partInfo) {
        Property prop;
        PartProperties partProperties = new PartProperties();
        if (partInfo.getPartProperties() != null) {
            for (Property property : partInfo.getPartProperties().getProperty()) {
                prop = new Property();
                prop.setName(property.getName());
                prop.setValue(property.getValue());
                partProperties.getProperty().add(prop);
            }
        }
        boolean mimeTypePropFound = false;
        for (Property property : partProperties.getProperty()) {
            if (!MIME_TYPE.equals(property.getName())) continue;
            mimeTypePropFound = true;
            break;
        }
        if (!mimeTypePropFound && payloadContentType != null) {
            prop = new Property();
            prop.setName(MIME_TYPE);
            prop.setValue(payloadContentType);
            partProperties.getProperty().add(prop);
        }
        partInfo.setPartProperties(partProperties);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=300)
    public ListPendingMessagesResponse listPendingMessages(Object listPendingMessagesRequest) {
        DomainDTO domainDTO = this.domainContextExtService.getCurrentDomainSafely();
        LOG.info("ListPendingMessages for domain [{}]", (Object)domainDTO);
        ListPendingMessagesResponse response = WEBSERVICE_OF.createListPendingMessagesResponse();
        int intMaxPendingMessagesRetrieveCount = this.wsPluginPropertyManager.getKnownIntegerPropertyValue("wsplugin.messages.pending.list.max");
        LOG.debug("maxPendingMessagesRetrieveCount [{}]", (Object)intMaxPendingMessagesRetrieveCount);
        String originalUser = null;
        if (!this.authenticationExtService.isUnsecureLoginAllowed()) {
            originalUser = this.authenticationExtService.getOriginalUser();
            LOG.info("Original user is [{}]", (Object)originalUser);
        }
        List<WSMessageLogEntity> pending = originalUser != null ? this.wsMessageLogDao.findAllByFinalRecipient(intMaxPendingMessagesRetrieveCount, originalUser) : this.wsMessageLogDao.findAll(intMaxPendingMessagesRetrieveCount);
        Collection ids = pending.stream().map(WSMessageLogEntity::getMessageId).collect(Collectors.toList());
        response.getMessageID().addAll(ids);
        return response;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=300, rollbackFor={RetrieveMessageFault.class})
    @MDCKey(value={"messageId"})
    public void retrieveMessage(RetrieveMessageRequest retrieveMessageRequest, Holder<RetrieveMessageResponse> retrieveMessageResponse, Holder<Messaging> ebMSHeaderInfo) throws RetrieveMessageFault {
        UserMessage userMessage;
        boolean isMessageIdNotEmpty = StringUtils.isNotEmpty((CharSequence)retrieveMessageRequest.getMessageID());
        if (!isMessageIdNotEmpty) {
            LOG.error(MESSAGE_ID_EMPTY);
            throw new RetrieveMessageFault(MESSAGE_ID_EMPTY, this.webServicePluginExceptionFactory.createFault("MessageId is empty"));
        }
        String trimmedMessageId = this.messageExtService.cleanMessageIdentifier(retrieveMessageRequest.getMessageID());
        WSMessageLogEntity wsMessageLogEntity = this.wsMessageLogDao.findByMessageId(trimmedMessageId);
        if (wsMessageLogEntity == null) {
            LOG.businessError(DomibusMessageCode.BUS_MSG_NOT_FOUND, new Object[]{trimmedMessageId});
            throw new RetrieveMessageFault(MESSAGE_NOT_FOUND_ID + trimmedMessageId + "]", this.webServicePluginExceptionFactory.createFault("No message with id [" + trimmedMessageId + "] pending for download"));
        }
        try {
            userMessage = (UserMessage)this.downloadMessage(trimmedMessageId, null);
        }
        catch (MessageNotFoundException mnfEx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MESSAGE_NOT_FOUND_ID + retrieveMessageRequest.getMessageID() + "]", (Throwable)mnfEx);
            }
            LOG.error(MESSAGE_NOT_FOUND_ID + retrieveMessageRequest.getMessageID() + "]");
            throw new RetrieveMessageFault(MESSAGE_NOT_FOUND_ID + trimmedMessageId + "]", this.webServicePluginExceptionFactory.createDownloadMessageFault((Exception)((Object)mnfEx)));
        }
        if (userMessage == null) {
            LOG.error(MESSAGE_NOT_FOUND_ID + retrieveMessageRequest.getMessageID() + "]");
            throw new RetrieveMessageFault(MESSAGE_NOT_FOUND_ID + trimmedMessageId + "]", this.webServicePluginExceptionFactory.createFault("UserMessage not found"));
        }
        if (StringUtils.isEmpty((CharSequence)userMessage.getCollaborationInfo().getAgreementRef().getValue())) {
            userMessage.getCollaborationInfo().setAgreementRef(null);
        }
        Messaging messaging = EBMS_OBJECT_FACTORY.createMessaging();
        messaging.setUserMessage(userMessage);
        ebMSHeaderInfo.value = messaging;
        retrieveMessageResponse.value = WEBSERVICE_OF.createRetrieveMessageResponse();
        this.fillInfoPartsForLargeFiles(retrieveMessageResponse, messaging);
        try {
            this.messageAcknowledgeExtService.acknowledgeMessageDelivered(trimmedMessageId, new Timestamp(System.currentTimeMillis()));
        }
        catch (AuthenticationExtException | MessageAcknowledgeExtException e) {
            LOG.error("Error acknowledging message [" + retrieveMessageRequest.getMessageID() + "]", e);
        }
        this.wsMessageLogDao.delete(wsMessageLogEntity);
    }

    private void fillInfoPartsForLargeFiles(Holder<RetrieveMessageResponse> retrieveMessageResponse, Messaging messaging) {
        if (this.getPayloadInfo(messaging) == null || CollectionUtils.isEmpty(this.getPartInfo(messaging))) {
            LOG.info("No payload found for message [{}]", (Object)messaging.getUserMessage().getMessageInfo().getMessageId());
            return;
        }
        for (PartInfo partInfo : this.getPartInfo(messaging)) {
            ExtendedPartInfo extPartInfo = (ExtendedPartInfo)partInfo;
            LargePayloadType payloadType = WEBSERVICE_OF.createLargePayloadType();
            if (extPartInfo.getPayloadDatahandler() != null) {
                LOG.debug("payloadDatahandler Content Type: " + extPartInfo.getPayloadDatahandler().getContentType());
                payloadType.setValue(extPartInfo.getPayloadDatahandler());
            }
            if (extPartInfo.isInBody()) {
                ((RetrieveMessageResponse)retrieveMessageResponse.value).setBodyload(payloadType);
                continue;
            }
            payloadType.setPayloadId(partInfo.getHref());
            ((RetrieveMessageResponse)retrieveMessageResponse.value).getPayload().add(payloadType);
        }
    }

    private PayloadInfo getPayloadInfo(Messaging messaging) {
        if (messaging.getUserMessage() == null) {
            return null;
        }
        return messaging.getUserMessage().getPayloadInfo();
    }

    private List<PartInfo> getPartInfo(Messaging messaging) {
        PayloadInfo payloadInfo = this.getPayloadInfo(messaging);
        if (payloadInfo == null) {
            return new ArrayList<PartInfo>();
        }
        return payloadInfo.getPartInfo();
    }

    @Override
    public MessageStatus getStatus(StatusRequest statusRequest) throws StatusFault {
        boolean isMessageIdNotEmpty = StringUtils.isNotEmpty((CharSequence)statusRequest.getMessageID());
        if (!isMessageIdNotEmpty) {
            LOG.error(MESSAGE_ID_EMPTY);
            throw new StatusFault(MESSAGE_ID_EMPTY, this.webServicePluginExceptionFactory.createFault("MessageId is empty"));
        }
        String trimmedMessageId = this.messageExtService.cleanMessageIdentifier(statusRequest.getMessageID());
        return this.defaultTransformer.transformFromMessageStatus(this.messageRetriever.getStatus(trimmedMessageId));
    }

    @Override
    public ErrorResultImplArray getMessageErrors(GetErrorsRequest messageErrorsRequest) {
        return this.defaultTransformer.transformFromErrorResults(this.messageRetriever.getErrorsForMessage(messageErrorsRequest.getMessageID()));
    }

    public MessageSubmissionTransformer<Messaging> getMessageSubmissionTransformer() {
        return this.defaultTransformer;
    }

    public MessageRetrievalTransformer<UserMessage> getMessageRetrievalTransformer() {
        return this.defaultTransformer;
    }
}

