/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.impl;

import eu.domibus.common.ErrorCode;
import eu.domibus.messaging.MessagingProcessingException;
import eu.domibus.plugin.webService.generated.FaultDetail;
import eu.domibus.plugin.webService.impl.WebServicePluginImpl;
import org.springframework.stereotype.Service;

@Service
public class WebServicePluginExceptionFactory {
    public FaultDetail createDownloadMessageFault(Exception ex) {
        FaultDetail detail = WebServicePluginImpl.WEBSERVICE_OF.createFaultDetail();
        detail.setCode(ErrorCode.EBMS_0004.getErrorCodeName());
        if (ex instanceof MessagingProcessingException) {
            MessagingProcessingException mpEx = (MessagingProcessingException)ex;
            detail.setCode(mpEx.getEbms3ErrorCode().getErrorCodeName());
            detail.setMessage(mpEx.getMessage());
        } else {
            detail.setMessage(ex.getMessage());
        }
        return detail;
    }

    public FaultDetail createFault(String message) {
        FaultDetail detail = WebServicePluginImpl.WEBSERVICE_OF.createFaultDetail();
        detail.setCode(ErrorCode.EBMS_0004.getErrorCodeName());
        detail.setMessage(message);
        return detail;
    }
}

