/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.impl;

import eu.domibus.common.ErrorResult;
import eu.domibus.common.MessageStatus;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.AgreementRef;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.CollaborationInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.From;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageProperties;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartProperties;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyId;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PayloadInfo;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Service;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.To;
import eu.domibus.common.model.org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import eu.domibus.ext.services.FileUtilExtService;
import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.Submission;
import eu.domibus.plugin.transformer.MessageRetrievalTransformer;
import eu.domibus.plugin.transformer.MessageSubmissionTransformer;
import eu.domibus.plugin.webService.generated.ErrorCode;
import eu.domibus.plugin.webService.generated.ErrorResultImpl;
import eu.domibus.plugin.webService.generated.ErrorResultImplArray;
import eu.domibus.plugin.webService.generated.MshRole;
import eu.domibus.plugin.webService.impl.ExtendedPartInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StubDtoTransformer
implements MessageSubmissionTransformer<Messaging>,
MessageRetrievalTransformer<UserMessage> {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(StubDtoTransformer.class);
    @Autowired
    FileUtilExtService fileUtilExtService;

    public UserMessage transformFromSubmission(Submission submission, UserMessage target) {
        return this.transformFromSubmission(submission);
    }

    public UserMessage transformFromSubmission(Submission submission) {
        UserMessage result = new UserMessage();
        result.setMpc(submission.getMpc());
        this.generateCollaborationInfo(submission, result);
        this.generateMessageInfo(submission, result);
        this.generatePartyInfo(submission, result);
        this.generatePayload(submission, result);
        this.generateMessageProperties(submission, result);
        return result;
    }

    private void generateMessageProperties(Submission submission, UserMessage result) {
        MessageProperties messageProperties = new MessageProperties();
        for (Submission.TypedProperty propertyEntry : submission.getMessageProperties()) {
            Property prop = new Property();
            prop.setName(propertyEntry.getKey());
            prop.setValue(propertyEntry.getValue());
            prop.setType(propertyEntry.getType());
            messageProperties.getProperty().add(prop);
        }
        result.setMessageProperties(messageProperties);
    }

    private void generateCollaborationInfo(Submission submission, UserMessage result) {
        CollaborationInfo collaborationInfo = new CollaborationInfo();
        collaborationInfo.setConversationId(submission.getConversationId());
        collaborationInfo.setAction(submission.getAction());
        AgreementRef agreementRef = new AgreementRef();
        agreementRef.setValue(submission.getAgreementRef());
        agreementRef.setType(submission.getAgreementRefType());
        collaborationInfo.setAgreementRef(agreementRef);
        Service service = new Service();
        service.setValue(submission.getService());
        service.setType(submission.getServiceType());
        collaborationInfo.setService(service);
        result.setCollaborationInfo(collaborationInfo);
    }

    private void generateMessageInfo(Submission submission, UserMessage result) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageId(submission.getMessageId());
        LOG.debug("MESSAGE ID " + messageInfo.getMessageId());
        messageInfo.setTimestamp(LocalDateTime.now());
        LOG.debug("TIMESTAMP " + messageInfo.getTimestamp());
        messageInfo.setRefToMessageId(submission.getRefToMessageId());
        result.setMessageInfo(messageInfo);
    }

    private void generatePartyInfo(Submission submission, UserMessage result) {
        PartyInfo partyInfo = new PartyInfo();
        From from = new From();
        from.setRole(submission.getFromRole());
        for (Submission.Party party : submission.getFromParties()) {
            PartyId partyId = new PartyId();
            partyId.setValue(party.getPartyId());
            partyId.setType(party.getPartyIdType());
            from.setPartyId(partyId);
        }
        partyInfo.setFrom(from);
        To to = new To();
        to.setRole(submission.getToRole());
        for (Submission.Party party : submission.getToParties()) {
            PartyId partyId = new PartyId();
            partyId.setValue(party.getPartyId());
            partyId.setType(party.getPartyIdType());
            to.setPartyId(partyId);
        }
        partyInfo.setTo(to);
        result.setPartyInfo(partyInfo);
    }

    private void generatePayload(Submission submission, UserMessage result) {
        PayloadInfo payloadInfo = new PayloadInfo();
        for (Submission.Payload payload : submission.getPayloads()) {
            ExtendedPartInfo partInfo = new ExtendedPartInfo();
            partInfo.setInBody(payload.isInBody());
            partInfo.setPayloadDatahandler(payload.getPayloadDatahandler());
            partInfo.setHref(payload.getContentId());
            PartProperties partProperties = new PartProperties();
            for (Submission.TypedProperty entry : payload.getPayloadProperties()) {
                Property property = new Property();
                property.setName(entry.getKey());
                property.setValue(entry.getValue());
                property.setType(entry.getType());
                partProperties.getProperty().add(property);
            }
            partInfo.setPartProperties(partProperties);
            payloadInfo.getPartInfo().add(partInfo);
            result.setPayloadInfo(payloadInfo);
        }
    }

    public Submission transformToSubmission(Messaging messageData) {
        return this.transformFromMessaging(messageData.getUserMessage());
    }

    public Submission transformFromMessaging(UserMessage messaging) {
        LOG.debug("Entered method: transformFromMessaging(final UserMessage messaging)");
        Submission result = new Submission();
        result.setMpc(messaging.getMpc());
        this.populateMessageInfo(result, messaging);
        this.populatePartyInfo(result, messaging);
        this.populateCollaborationInfo(result, messaging);
        this.populateMessageProperties(result, messaging);
        this.populatePayloadInfo(result, messaging);
        return result;
    }

    private void populateMessageInfo(Submission result, UserMessage messaging) {
        MessageInfo messageInfo = messaging.getMessageInfo();
        if (result == null || messageInfo == null) {
            return;
        }
        LOG.debug("Populating MessageInfo");
        result.setMessageId(messageInfo.getMessageId());
        result.setRefToMessageId(messageInfo.getRefToMessageId());
    }

    private void populatePartyInfo(Submission result, UserMessage messaging) {
        PartyId partyId;
        PartyInfo partyInfo = messaging.getPartyInfo();
        if (result == null || partyInfo == null) {
            return;
        }
        LOG.debug("Populating PartyInfo");
        if (partyInfo.getFrom() != null) {
            partyId = partyInfo.getFrom().getPartyId();
            if (partyId != null) {
                result.addFromParty(partyId.getValue(), partyId.getType());
            }
            result.setFromRole(partyInfo.getFrom().getRole());
        }
        if (partyInfo.getTo() != null) {
            partyId = partyInfo.getTo().getPartyId();
            if (partyId != null) {
                result.addToParty(partyId.getValue(), partyId.getType());
            }
            result.setToRole(partyInfo.getTo().getRole());
        }
    }

    private void populateCollaborationInfo(Submission result, UserMessage messaging) {
        CollaborationInfo collaborationInfo = messaging.getCollaborationInfo();
        if (result == null || collaborationInfo == null) {
            return;
        }
        LOG.debug("Populating CollaborationInfo");
        result.setAction(collaborationInfo.getAction());
        if (collaborationInfo.getService() != null) {
            result.setService(collaborationInfo.getService().getValue());
            result.setServiceType(collaborationInfo.getService().getType());
        }
        if (collaborationInfo.getAgreementRef() != null) {
            result.setAgreementRef(collaborationInfo.getAgreementRef().getValue());
            result.setAgreementRefType(collaborationInfo.getAgreementRef().getType());
        }
        result.setConversationId(collaborationInfo.getConversationId());
    }

    private void populateMessageProperties(Submission result, UserMessage messaging) {
        if (result == null || messaging.getMessageProperties() == null) {
            return;
        }
        LOG.debug("Populating MessageProperties");
        for (Property property : messaging.getMessageProperties().getProperty()) {
            result.addMessageProperty(property.getName(), property.getValue(), property.getType());
        }
    }

    private void populatePayloadInfo(Submission result, UserMessage messaging) {
        PayloadInfo payloadInfo = messaging.getPayloadInfo();
        if (result == null || payloadInfo == null) {
            return;
        }
        LOG.debug("Populating PayloadInfo");
        for (PartInfo partInfo : payloadInfo.getPartInfo()) {
            ExtendedPartInfo extPartInfo = (ExtendedPartInfo)partInfo;
            ArrayList<Submission.TypedProperty> properties = new ArrayList<Submission.TypedProperty>();
            if (extPartInfo.getPartProperties() != null) {
                for (Property property : extPartInfo.getPartProperties().getProperty()) {
                    String propertyName = StringUtils.trim((String)property.getName());
                    String propertyValue = StringUtils.trim((String)property.getValue());
                    if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"PayloadName")) {
                        LOG.debug("{} property found=[{}]", (Object)propertyName, (Object)propertyValue);
                        propertyValue = this.fileUtilExtService.sanitizeFileName(propertyValue);
                    }
                    properties.add(new Submission.TypedProperty(propertyName, propertyValue, StringUtils.trim((String)property.getType())));
                }
            }
            result.addPayload(extPartInfo.getHref(), extPartInfo.getPayloadDatahandler(), properties, extPartInfo.isInBody(), null, null);
        }
    }

    public eu.domibus.plugin.webService.generated.MessageStatus transformFromMessageStatus(MessageStatus messageStatus) {
        return eu.domibus.plugin.webService.generated.MessageStatus.fromValue(messageStatus.name());
    }

    public ErrorResultImplArray transformFromErrorResults(List<? extends ErrorResult> errors) {
        ErrorResultImplArray errorList = new ErrorResultImplArray();
        for (ErrorResult errorResult : errors) {
            ErrorResultImpl errorResultImpl = new ErrorResultImpl();
            errorResultImpl.setErrorCode(ErrorCode.fromValue(errorResult.getErrorCode().name()));
            errorResultImpl.setErrorDetail(errorResult.getErrorDetail());
            errorResultImpl.setMshRole(MshRole.fromValue(errorResult.getMshRole().name()));
            errorResultImpl.setMessageInErrorId(errorResult.getMessageInErrorId());
            LocalDateTime dateTime = LocalDateTime.now();
            if (errorResult.getNotified() != null) {
                dateTime = errorResult.getNotified().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            errorResultImpl.setNotified(dateTime);
            if (errorResult.getTimestamp() != null) {
                dateTime = errorResult.getTimestamp().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            errorResultImpl.setTimestamp(dateTime);
            errorList.getItem().add(errorResultImpl);
        }
        return errorList;
    }
}

