/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.impl;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.springframework.stereotype.Component;

@Component
public class HttpMethodAuthorizationInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(HttpMethodAuthorizationInInterceptor.class);

    public HttpMethodAuthorizationInInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        String httpMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (StringUtils.equalsIgnoreCase((CharSequence)httpMethod, (CharSequence)"GET")) {
            LOG.debug("Detected GET request: aborting the interceptor chain");
            message.getInterceptorChain().abort();
            HttpServletResponse httpResponse = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            httpResponse.setStatus(405);
            httpResponse.addHeader("Allow", "POST");
            return;
        }
    }
}

