/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.impl;

import eu.domibus.ext.exceptions.AuthenticationExtException;
import eu.domibus.ext.services.AuthenticationExtService;
import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="customAuthenticationInterceptor")
public class CustomAuthenticationInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(CustomAuthenticationInterceptor.class);
    @Autowired
    private AuthenticationExtService authenticationExtService;

    public CustomAuthenticationInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        HttpServletRequest httpRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        LOG.debug("Intercepted request for " + httpRequest.getPathInfo());
        try {
            this.authenticationExtService.authenticate(httpRequest);
        }
        catch (AuthenticationExtException e) {
            throw new Fault((Throwable)e);
        }
    }
}

