/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.dao;

import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.webService.dao.WSBasicDao;
import eu.domibus.plugin.webService.entity.WSMessageLogEntity;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class WSMessageLogDao
extends WSBasicDao<WSMessageLogEntity> {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(WSMessageLogDao.class);
    private static final String MESSAGE_ID = "MESSAGE_ID";
    private static final String MESSAGE_IDS = "MESSAGE_IDS";
    private static final String FINAL_RECIPIENT = "FINAL_RECIPIENT";

    public WSMessageLogDao() {
        super(WSMessageLogEntity.class);
    }

    public WSMessageLogEntity findByMessageId(String messageId) {
        WSMessageLogEntity wsMessageLogEntity;
        TypedQuery query = this.em.createNamedQuery("WSMessageLogEntity.findByMessageId", WSMessageLogEntity.class);
        query.setParameter(MESSAGE_ID, (Object)messageId);
        try {
            wsMessageLogEntity = (WSMessageLogEntity)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
        return wsMessageLogEntity;
    }

    public List<WSMessageLogEntity> findAll(int maxCount) {
        TypedQuery query = this.em.createNamedQuery("WSMessageLogEntity.findAll", WSMessageLogEntity.class);
        if (maxCount > 0) {
            return query.setMaxResults(maxCount).getResultList();
        }
        return query.getResultList();
    }

    public List<WSMessageLogEntity> findAllByFinalRecipient(int maxCount, String finalRecipient) {
        TypedQuery query = this.em.createNamedQuery("WSMessageLogEntity.findAllByFinalRecipient", WSMessageLogEntity.class);
        query.setParameter(FINAL_RECIPIENT, (Object)finalRecipient);
        if (maxCount > 0) {
            return query.setMaxResults(maxCount).getResultList();
        }
        return query.getResultList();
    }

    public List<WSMessageLogEntity> findAll() {
        TypedQuery query = this.em.createNamedQuery("WSMessageLogEntity.findAll", WSMessageLogEntity.class);
        return query.getResultList();
    }

    public void deleteByMessageId(String messageId) {
        Query query = this.em.createNamedQuery("WSMessageLogEntity.deleteByMessageId");
        query.setParameter(MESSAGE_ID, (Object)messageId);
        query.executeUpdate();
    }

    public void deleteByMessageIds(List<String> messageIds) {
        Query query = this.em.createNamedQuery("WSMessageLogEntity.deleteByMessageIds");
        query.setParameter(MESSAGE_IDS, messageIds);
        query.executeUpdate();
    }
}

