/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.dao;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.transaction.annotation.Transactional;

public abstract class WSBasicDao<T> {
    protected final Class<T> typeOfT;
    @PersistenceContext(unitName="domibusJTA")
    protected EntityManager em;

    public WSBasicDao(Class<T> typeOfT) {
        this.typeOfT = typeOfT;
    }

    public <T> T findById(Class<T> typeOfT, String id) {
        return (T)this.em.find(typeOfT, (Object)id);
    }

    @Transactional
    public void create(T entity) {
        this.em.persist(entity);
    }

    @Transactional
    public void delete(T entity) {
        this.em.remove(this.em.merge(entity));
    }

    public T read(long id) {
        return (T)this.em.find(this.typeOfT, (Object)id);
    }

    @Transactional
    public void updateAll(Collection<T> update) {
        for (T t : update) {
            this.update(t);
        }
    }

    @Transactional
    public void deleteAll(Collection<T> delete) {
        for (T t : delete) {
            this.delete(t);
        }
    }

    @Transactional
    public void update(T entity) {
        this.em.merge(entity);
    }
}

