/*
 * Decompiled with CFR 0.152.
 */
package eu.domibus.plugin.webService.configuration;

import eu.domibus.ext.services.DomibusPropertyExtService;
import eu.domibus.logging.DomibusLogger;
import eu.domibus.logging.DomibusLoggerFactory;
import eu.domibus.plugin.BackendConnector;
import eu.domibus.plugin.environment.DomibusEnvironmentUtil;
import eu.domibus.plugin.notification.PluginAsyncNotificationConfiguration;
import eu.domibus.plugin.webService.impl.ClearAuthenticationMDCInterceptor;
import eu.domibus.plugin.webService.impl.CustomAuthenticationInterceptor;
import eu.domibus.plugin.webService.impl.HttpMethodAuthorizationInInterceptor;
import eu.domibus.plugin.webService.impl.WSPluginFaultOutInterceptor;
import eu.domibus.plugin.webService.impl.WebServicePluginImpl;
import eu.domibus.plugin.webService.logging.WSPluginLoggingEventSender;
import eu.domibus.plugin.webService.property.WSPluginPropertyManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Queue;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class WSPluginConfiguration {
    private static final DomibusLogger LOG = DomibusLoggerFactory.getLogger(WSPluginConfiguration.class);
    public static final String NOTIFY_BACKEND_QUEUE_JNDI = "jms/domibus.notification.webservice";
    public static final String DOMIBUS_LOGGING_PAYLOAD_PRINT = "domibus.logging.payload.print";
    public static final String DOMIBUS_LOGGING_METADATA_PRINT = "domibus.logging.metadata.print";
    public static final String DOMIBUS_LOGGING_CXF_LIMIT = "domibus.logging.cxf.limit";

    @Bean(value={"backendWebservice"})
    public WebServicePluginImpl createWSPlugin(DomibusPropertyExtService domibusPropertyExtService) {
        List messageNotifications = domibusPropertyExtService.getConfiguredNotifications("wsplugin.messages.notifications");
        LOG.debug("Using the following message notifications [{}]", (Object)messageNotifications);
        WebServicePluginImpl webServicePlugin = new WebServicePluginImpl();
        webServicePlugin.setRequiredNotifications(messageNotifications);
        return webServicePlugin;
    }

    @Bean(value={"webserviceAsyncPluginConfiguration"})
    public PluginAsyncNotificationConfiguration pluginAsyncNotificationConfiguration(@Qualifier(value="notifyBackendWebServiceQueue") Queue notifyBackendWebServiceQueue, WebServicePluginImpl backendWebService, Environment environment) {
        PluginAsyncNotificationConfiguration pluginAsyncNotificationConfiguration = new PluginAsyncNotificationConfiguration((BackendConnector)backendWebService, notifyBackendWebServiceQueue);
        if (DomibusEnvironmentUtil.INSTANCE.isApplicationServer(environment)) {
            String queueNotificationJndi = NOTIFY_BACKEND_QUEUE_JNDI;
            LOG.debug("Domibus is running inside an application server. Setting the queue name to [{}]", (Object)queueNotificationJndi);
            pluginAsyncNotificationConfiguration.setQueueName(queueNotificationJndi);
        }
        return pluginAsyncNotificationConfiguration;
    }

    @Bean(value={"wsPluginLoggingEventSender"})
    public WSPluginLoggingEventSender wsPluginLoggingEventSender(DomibusPropertyExtService domibusPropertyExtService) {
        Boolean payloadPrint = domibusPropertyExtService.getBooleanProperty(DOMIBUS_LOGGING_PAYLOAD_PRINT);
        LOG.debug("Property [{}] value is [{}]", (Object)DOMIBUS_LOGGING_PAYLOAD_PRINT, (Object)payloadPrint);
        Boolean metadataPrint = domibusPropertyExtService.getBooleanProperty(DOMIBUS_LOGGING_METADATA_PRINT);
        LOG.debug("Property [{}] value is [{}]", (Object)DOMIBUS_LOGGING_METADATA_PRINT, (Object)metadataPrint);
        WSPluginLoggingEventSender wsPluginLoggingEventSender = new WSPluginLoggingEventSender();
        wsPluginLoggingEventSender.setPrintPayload(payloadPrint);
        wsPluginLoggingEventSender.setPrintMetadata(metadataPrint);
        return wsPluginLoggingEventSender;
    }

    @Bean(value={"backendInterfaceEndpoint"})
    public Endpoint backendInterfaceEndpoint(@Qualifier(value="cxf") Bus bus, WebServicePluginImpl backendWebService, WSPluginPropertyManager wsPluginPropertyManager, HttpMethodAuthorizationInInterceptor httpMethodAuthorizationInInterceptor, CustomAuthenticationInterceptor customAuthenticationInterceptor, ClearAuthenticationMDCInterceptor clearAuthenticationMDCInterceptor, WSPluginFaultOutInterceptor wsPluginFaultOutInterceptor, @Qualifier(value="wsLoggingFeature") LoggingFeature wsLoggingFeature) {
        EndpointImpl endpoint = new EndpointImpl(bus, (Object)backendWebService);
        Map<String, Object> endpointProperties = this.getEndpointProperties(wsPluginPropertyManager);
        endpoint.setProperties(endpointProperties);
        endpoint.setSchemaLocations(this.getSchemaLocations());
        endpoint.setInInterceptors(Arrays.asList(new Interceptor[]{httpMethodAuthorizationInInterceptor, customAuthenticationInterceptor}));
        endpoint.setOutInterceptors(Collections.singletonList(clearAuthenticationMDCInterceptor));
        endpoint.setOutFaultInterceptors(Arrays.asList(new Interceptor[]{wsPluginFaultOutInterceptor, clearAuthenticationMDCInterceptor}));
        endpoint.setFeatures(Collections.singletonList(wsLoggingFeature));
        endpoint.publish("/backend");
        return endpoint;
    }

    @Bean(value={"wsLoggingFeature"})
    public LoggingFeature wsLoggingFeature(WSPluginLoggingEventSender wsPluginLoggingEventSender, DomibusPropertyExtService domibusPropertyExtService) {
        LoggingFeature loggingFeature = new LoggingFeature();
        loggingFeature.setSender((LogEventSender)wsPluginLoggingEventSender);
        Integer loggingLimit = domibusPropertyExtService.getIntegerProperty(DOMIBUS_LOGGING_CXF_LIMIT);
        LOG.debug("Using logging limit [{}]", (Object)loggingLimit);
        loggingFeature.setLimit(loggingLimit.intValue());
        return loggingFeature;
    }

    private List<String> getSchemaLocations() {
        return Arrays.asList("schemas/domibus-header.xsd", "schemas/domibus-backend.xsd", "schemas/xml.xsd", "schemas/xmlmime.xsd");
    }

    protected Map<String, Object> getEndpointProperties(WSPluginPropertyManager wsPluginPropertyManager) {
        String schemaValidationEnabled = wsPluginPropertyManager.getKnownPropertyValue("wsplugin.schema.validation.enabled");
        LOG.debug("Is schema validation enabled [{}]?", (Object)schemaValidationEnabled);
        String mtomEnabled = wsPluginPropertyManager.getKnownPropertyValue("wsplugin.mtom.enabled");
        LOG.debug("Is MTOM enabled [{}]?", (Object)mtomEnabled);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("schema-validation-enabled", schemaValidationEnabled);
        properties.put("mtom-enabled", mtomEnabled);
        return properties;
    }
}

